<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

final class CreateMonitorLogsTable extends Migration
{
    public function up(): void
    {
        Schema::create('monitor_logs', static function (Blueprint $table) {
            $table->id();
            $table->foreignId('log_type_id')->nullable();
            $table->foreignId('monitor_rule_id')->nullable();
            $table->foreignId('system_id')->nullable();
            $table->foreignId('client_id')->nullable();
            $table->string('client_name')->nullable();
            $table->foreignId('connector_id')->nullable();
            $table->string('connector_name')->nullable();
            $table->foreignId('entity_type_id')->nullable();
            $table->string('entity_id')->index()->nullable();
            $table->integer('status_code')->nullable();
            $table->text('message')->nullable();
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('monitor_logs');
    }
}
