<?php

declare(strict_types=1);

namespace Hexspoor\PortalClient;

use Hexspoor\PortalClient\Contracts\ClientContract;
use Illuminate\Contracts\Config\Repository;
use Illuminate\Contracts\Container\Container;
use Illuminate\Contracts\Support\DeferrableProvider;

final class ServiceProvider extends \Illuminate\Support\ServiceProvider implements DeferrableProvider
{
    public function register()
    {
        $this->app->singleton(ClientContract::class, function (Container $container) {
            /** @var \Illuminate\Contracts\Config\Repository $config */
            $config = $container->make(Repository::class);

            return new Client(
                $config->get('portal.url'),
                $config->get('portal.token')
            );
        });
    }

    /**
     * Perform post-registration booting of services.
     *
     * @return void
     */
    public function boot()
    {
        $this->publishes([
            __DIR__ . '/../config/portal.php' => config_path('portal.php'),
        ]);

        $this->mergeConfigFrom(__DIR__ . '/../config/portal.php', 'portal');
    }

    public function provides()
    {
        return [ClientContract::class];
    }
}
