<?php

declare(strict_types=1);

namespace Hexspoor\PortalClient;

use Hexspoor\PortalClient\Contracts\ClientContract;
use Hexspoor\PortalClient\Models\Permission;
use Illuminate\Http\Client\Response;
use Illuminate\Support\Facades\Http;
use function json_encode;
use function trim;

final class Client implements ClientContract
{
    private string $url;

    private string $token;

    public function __construct(string $url, string $token)
    {
        $this->url = $url;
        $this->token = $token;
    }

    public function postPermissions(array $permissions): Response
    {
        $permissions = array_map(static function (Permission $permission) {
            return $permission->toArray();
        }, $permissions);

        return $this->put('permission', json_encode(['permissions' => $permissions]));
    }

    public function put(string $endpoint, string $content): Response
    {
        $request = Http::withToken($this->token);

        return $request
            ->withBody($content, 'application/json')
            ->put($this->formatUrl('microservice/' . $endpoint));
    }

    private function formatUrl(string $url): string
    {
        $baseUrl = trim($this->url, '/');

        return "{$baseUrl}/{$url}";
    }
}
