<?php

declare(strict_types=1);

namespace Hexspoor\PortalClient\Models;

final class Permission
{
    private string $key;

    private string $name;

    public function __construct(string $key, string $name)
    {
        $this->key = $key;
        $this->name = $name;
    }

    public function getKey(): string
    {
        return $this->key;
    }

    public function getName(): string
    {
        return $this->name;
    }

    public function toArray(): array
    {
        return [
            'key'  => $this->key,
            'name' => $this->name,
        ];
    }
}
