<?php

declare(strict_types=1);

namespace Hexspoor\TranslatorClient\Contracts;

use Illuminate\Http\Client\Response;

interface ClientContract
{
    public function postSalesOrder(
        int $connectorId,
        string $content,
        string $contentType = 'application/json'
    ): Response;

    public function postStockValue(
        int $connectorId,
        string $content,
        string $contentType = 'application/json'
    ): Response;

    public function postShipment(
        int $connectorId,
        string $content,
        string $contentType = 'application/json'
    ): Response;

    public function postProduct(
        int $connectorId,
        string $content,
        string $contentType = 'application/json'
    ): Response;

    public function postIdentification(
        int $connectorId,
        int $messageId,
        string $identifier
    ): Response;
}
