<?php

declare(strict_types=1);

namespace Hexspoor\TranslatorClient;

use Hexspoor\TranslatorClient\Contracts\ClientContract;
use Illuminate\Contracts\Config\Repository;
use Illuminate\Contracts\Container\Container;
use Illuminate\Contracts\Support\DeferrableProvider;
use function config_path;

final class ServiceProvider extends \Illuminate\Support\ServiceProvider implements DeferrableProvider
{
    public function register()
    {
        $this->app->singleton(ClientContract::class, function (Container $container) {
            /** @var \Illuminate\Contracts\Config\Repository $config */
            $config = $container->make(Repository::class);

            return new Client($config->get('translator.url', ''), $config->get('translator.token', ''));
        });
    }

    /**
     * Perform post-registration booting of services.
     *
     * @return void
     */
    public function boot()
    {
        $this->publishes([
            __DIR__ . '/../config/translator.php' => config_path('translator.php'),
        ]);

        $this->mergeConfigFrom(__DIR__ . '/../config/translator.php', 'translator');
    }

    public function provides()
    {
        return [ClientContract::class];
    }
}
